package Plugins::MoreShuffle::Plugin;

use strict;

use Slim::Utils::Strings qw(cstring);

sub initPlugin {
	my $class = shift;
	
	# Track Info handler
	Slim::Menu::TrackInfo->registerInfoProvider( infoMoreShuffle => (
		before => 'top',
		func   => \&infoHandler,
	) );
	
	# Playlist Info handler
	Slim::Menu::PlaylistInfo->registerInfoProvider( infoMoreShuffle => (
		before => 'top',
		func   => \&infoHandler,
	) );
	
	# Album Info handler
	Slim::Menu::AlbumInfo->registerInfoProvider( infoMoreShuffle => (
		before => 'top',
		func   => \&infoHandler,
	) );
	
	# Artist Info handler
	Slim::Menu::ArtistInfo->registerInfoProvider( infoMoreShuffle => (
		before => 'top',
		func   => \&infoHandler,
	) );
	
	# Genre Info handler
	Slim::Menu::GenreInfo->registerInfoProvider( infoMoreShuffle => (
		before => 'top',
		func   => \&infoHandler,
	) );
	
	# Year Info handler
	Slim::Menu::YearInfo->registerInfoProvider( infoMoreShuffle => (
		before => 'top',
		func   => \&infoHandler,
	) );
}

sub getDisplayName { 'PLUGIN_MORESHUFFLE_MODULE_NAME' }

# Don't add this item to any menu
sub playerMenu { }

sub infoHandler {
	my ( $client, $url, $track ) = @_;
	
	my $item;
	my $action;
	my $val = Slim::Player::Playlist::shuffle($client);
	
	# If Random Play mode is active, offer to stop it
	if (   exists $INC{'Slim/Plugin/RandomPlay/Plugin.pm'} 
		&& Slim::Plugin::RandomPlay::Plugin::active($client)
	)
	{
		$action = 
		{
			command     => [ 'playlist', 'clear'],
		};
		$item = {
			itemActions => {
				play  => $action,
				items => $action,
			},
			nextWindow  => 'refresh',
			name        => 'Shuffle NA: Stop Random Mix',
			type        => 'text',
		};
	}
	elsif( $val == 0)
	{
		$action = 
		{
			command     => [ 'playlist', 'shuffle', 1 ],
		};
		$item = {
			itemActions => {
				play  => $action,
				items => $action,
			},
			nextWindow  => 'refresh',
			name        => 'Shuffle is OFF: Turn ON',
			type        => 'text',
		};
	}
	else
	{
		$action = 
		{
			command     => [ 'playlist', 'shuffle', 0 ],
		};
		$item = {
			itemActions => {
				play  => $action,
				items => $action,
			},
			nextWindow  => 'refresh',
			type        => 'text',
			name        => 'Shuffle is ON: Turn OFF',
		};
	}
	
	return $item;
}

1;