package com.natergator.udptest;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;

import android.app.Activity;
import android.content.Context;
import android.net.DhcpInfo;
import android.net.wifi.WifiManager;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.SeekBar;
import android.widget.SlidingDrawer;
import android.widget.Switch;
import android.widget.TextView;

/*
 * Hackish, but it gets the job done quickly 
 */
public class UdpTestActivity extends Activity {
	Timer t = null;
	public int sent_packets = 0;     //Sent packets count
	public int recv_packets = 0;     //Recv packets count
	public int bytes = 0;            //Recv bytes   count
	public DatagramSocket dsocket;   //UDP socket
	public String address;           //
	public final byte[] ssp_discover_bcast_bytes = new String("\u0065\u0049\u0000\u0041\u0044\u0000\u004e\u0041\u004d\u0045\u0000\u004a\u0053\u004f\u004e\u0000\u0056\u0045\u0052\u0053\u0000\u0055\u0055\u0049\u0044\u0000").getBytes();
    /** Called when the activity is first created. */
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
    	//Setup the UDP socket
		try {
			dsocket = new DatagramSocket(4523); //Any random unused port will do
			dsocket.setBroadcast(true);         //Turn on broadcasting
			dsocket.setSoTimeout(100);          //A reasonable timeout
		} catch (SocketException e) {
			// TODO Auto-generated catch block
			Log.e("UdpTest", "Can't create the dsocket");			
			e.printStackTrace();
			return;
		}
        setContentView(R.layout.main);
        
        ((SeekBar)findViewById(R.id.rateBar)).setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener() {
			
			@Override
			public void onStopTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
				Switch sw = (Switch)findViewById(R.id.switch1);
				if(sw.isChecked()) {
					if(t != null) {
						t.cancel();
						t.purge();
					}
					t = new Timer();
					t.schedule(new UdpBroadcastTask(), 0, 100+seekBar.getProgress());

				}
			}
			
			@Override
			public void onStartTrackingTouch(SeekBar seekBar) {
				// TODO Auto-generated method stub
				
			}
			
			@Override
			public void onProgressChanged(SeekBar seekBar, int progress,
					boolean fromUser) {
				// TODO Auto-generated method stub
				if (fromUser)
					((TextView)findViewById(R.id.rateValue)).setText(String.format("%1.2fs", (100.0+seekBar.getProgress())/1000.0));
				
			}
		});
        
        Button sw = (Button) findViewById(R.id.switch1);
        sw.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				Switch sw = (Switch)v;
				if(sw.isChecked()) {
					t = new Timer();
					t.schedule(new UdpBroadcastTask(), 0, 100 + ((SeekBar)findViewById(R.id.rateBar)).getProgress());
				} else {
					if (t != null) {
						t.cancel();
						t.purge();
						t = null;
					}
				}
			}
		});
        
        UdpListenThread lt = new UdpListenThread();
        lt.start();
    }
    
    /*
     * Credit to: http://code.google.com/p/boxeeremote/source/browse/trunk/Boxee+Remote/src/com/andrewchatham/Discoverer.java?spec=svn28&r=28
     */
    InetAddress getBroadcastAddress() {
        WifiManager wifi = (WifiManager) getSystemService(Context.WIFI_SERVICE);
        DhcpInfo dhcp = wifi.getDhcpInfo();
        // handle null somehow

        int broadcast = (dhcp.ipAddress & dhcp.netmask) | ~dhcp.netmask;
        byte[] quads = new byte[4];
        for (int k = 0; k < 4; k++)
          quads[k] = (byte) ((broadcast >> k * 8) & 0xFF);
        try {
			return InetAddress.getByAddress(quads);
		} catch (UnknownHostException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			return null;
		}
    }
    
    /*
     * Hackish but simple listener thread testing:
     *     http://code.google.com/p/android/issues/detail?id=24748
     */
    class UdpListenThread extends Thread {
    	@Override
    	public void run() {
    		byte[] response = new byte[1024];
			DatagramPacket rpacket = new DatagramPacket(response, 1024);
    		while(true) {
        		try {
        			dsocket.receive(rpacket);
        			address = rpacket.getAddress().toString();
        			bytes  += rpacket.getLength();
        			recv_packets += 1;
        			
        			runOnUiThread(new Runnable() {
						
						@Override
						public void run() {
							((TextView)findViewById(R.id.recvText)).setText("" + recv_packets);
							((TextView)findViewById(R.id.responseIp)).setText(address);
							((TextView)findViewById(R.id.recvBytes)).setText("" + bytes);
						}
					});
        		} catch (IOException e) {
        			//Ignore the timeout
    			}	
    		}
    	}
    }
    
    /*
     * Interval timer task to dispatch the generic Logitech Media Server discovery packet
     */
    class UdpBroadcastTask extends TimerTask {
    	public void run() {

    		DatagramPacket packet = new DatagramPacket(ssp_discover_bcast_bytes, ssp_discover_bcast_bytes.length, getBroadcastAddress(), 3483); //3483 is LMS discovery port
    		try {
    			dsocket.send(packet);
    			sent_packets += 1;
    			runOnUiThread(new Runnable() {
    				
    				@Override
    				public void run() {
    		    		((TextView)findViewById(R.id.packetsText)).setText("" + sent_packets);
    				}
    			});
    		} catch (IOException e) {
    			// TODO Auto-generated catch block
    			e.printStackTrace();
    		}
    	}
    }
}


