SELECT genres.name AS GenreName, utf8toansi([albums].[title]) AS AlbumTitle, tracks.id AS TrackID, UTF8ToAnsi([tracks].[title]) AS TrackTitle, tracks.tracknum, contributor_track.role, contributor_role.rolename, utf8toansi([contributors].[name]) AS ContribName, tracks.url, tracks.ct
FROM (((((tracks LEFT JOIN contributor_track ON tracks.id = contributor_track.track) LEFT JOIN contributor_role ON contributor_track.role = contributor_role.id) LEFT JOIN contributors ON contributor_track.contributor = contributors.id) LEFT JOIN albums ON tracks.album = albums.id) LEFT JOIN genre_track ON tracks.id = genre_track.track) LEFT JOIN genres ON genre_track.genre = genres.id
WHERE (((tracks.url) Like "file:///C:/Recordings/Music_Beta/FLAC_GenreZ_With_Emb*"))
ORDER BY genres.namesort, albums.titlesort, tracks.tracknum, contributor_track.role, contributors.namesort;
