# StringEditor::Plugin.pm by mh jan 2005
#
# This code is derived from code with the following copyright message:
#
# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

package Plugins::TuneIn::Plugin;

use strict;
use Slim::Utils::Strings qw (string);

sub initPlugin {
	# remove link in player menu manually - we need addMenu to get this plugin to the radio settings page...
	Slim::Buttons::Home::delSubMenu("RADIO", 'PLUGIN_TUNEIN');
}

sub addMenu {
	return 'RADIO';
}

sub getDisplayName {
	return 'PLUGIN_TUNEIN';
}

sub webPages {
	my %pages = ("index\.htm" => \&handleWebIndex);

	if (grep {$_ eq 'TuneIn::Plugin'} Slim::Utils::Prefs::getArray('disabledplugins')) {
		Slim::Web::Pages::addLinks("radio", { 'PLUGIN_TUNEIN' => undef });
	} else {
		Slim::Web::Pages::addLinks("radio", { 'PLUGIN_TUNEIN' => "plugins/TuneIn/index.html" });
	}

	return (\%pages);
}

sub handleWebIndex {
	my ($client, $params) = @_;
	return Slim::Web::HTTP::filltemplatefile('plugins/TuneIn/index.html', $params);
}

sub strings { 
	return q^
PLUGIN_TUNEIN
	DE	Manuelle Radio Einwahl
	EN	Radio Tune In

PLUGIN_TUNEIN_NOW
	DE	Manuelle Radio Einwahl
	EN	Tune In Now

PLUGIN_TUNEIN_DESC
	DE	Falls Sie die URL einer Internet-Radiostation bereits kennen, so können Sie diese hier eingeben und "Station wählen" drücken. Sie können die URL des Streams selber (z.B. http://62.49.59.50:8000) oder einer Playlist, die darauf verweist (z.B. http://www.hitzradio.com/hitzradio.pls), angeben.
	EN	If you already know the URL of the station you would like to listen to, enter it below and click on the "Tune In" button. You can enter the URL of either the radio stream itself (e.g. http://62.49.59.50:8000) or the playlist file that is pointing to the stream (e.g. http://www.hitzradio.com/hitzradio.pls).	

PLUGIN_TUNEIN_RADIOURL
	EN	Radio URL:

PLUGIN_TUNEIN_CHOOSE
	DE	Station wählen
	EN	Tune In
^;
}

1;