# StringEditor::Plugin.pm by mh jan 2005
#
# This code is derived from code with the following copyright message:
#
# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

package Plugins::TuneIn::Plugin;

use strict;
use Slim::Utils::Strings qw (string);


sub getDisplayName {
	return 'PLUGIN_TUNEIN';
}

sub webPages {
	my %pages = ("index\.htm" => \&handleWebIndex);

	if (grep {$_ eq 'TuneIn::Plugin'} Slim::Utils::Prefs::getArray('disabledplugins')) {
		Slim::Web::Pages::addLinks("radio", { 'PLUGIN_TUNEIN' => undef });
	} else {
		Slim::Web::Pages::addLinks("radio", { 'PLUGIN_TUNEIN' => "plugins/TuneIn/index.html" });
	}

	return (\%pages);
}

sub handleWebIndex {
	my ($client, $params) = @_;
	return Slim::Web::HTTP::filltemplatefile('plugins/TuneIn/index.html', $params);
}


sub strings { 
	return q^
PLUGIN_TUNEIN
	DE	Manuelle Radio Einwahl
	EN	Radio Tune In

PLUGIN_TUNEIN_NOW
	EN	Tune In Now

PLUGIN_TUNEIN_DESC
	EN	If you already know the URL of the station you would like to listen to, enter it below and click on the "Tune In" button. You can enter the URL of either the radio stream itself (e.g. http://62.49.59.50:8000) or the playlist file that is pointing to the stream (e.g. http://www.hitzradio.com/hitzradio.pls).	
^;
}

1;