
--[[
=head1 NAME

applets.MemLeak.MemLeakApplet - Applet to show zoom memleak

=head1 DESCRIPTION

MemLeak is a screen saver applet for Squeezeplay that shows a memleak in zoom function call.

=head1 FUNCTIONS

Applet related methods are described in L<jive.Applet>. CustomClockApplet overrides the
following methods:

=cut
--]]


-- stuff we use
local pairs, ipairs, tostring, tonumber,collectgarbage = pairs, ipairs, tostring, tonumber,collectgarbage

local oo               = require("loop.simple")
local os               = require("os")
local math             = require("math")
local string           = require("jive.utils.string")
local table            = require("jive.utils.table")
local debug            = require("jive.utils.debug")

local Applet           = require("jive.Applet")
local Window           = require("jive.ui.Window")
local Group            = require("jive.ui.Group")
local Canvas           = require("jive.ui.Canvas")
local Icon             = require("jive.ui.Icon")
local Tile             = require("jive.ui.Tile")
local Surface          = require("jive.ui.Surface")
local Framework        = require("jive.ui.Framework")

local appletManager    = appletManager
local jiveMain         = jiveMain
local jnt              = jnt

local FRAME_RATE	= jive.ui.FRAME_RATE

local IMG_PATH          = "applets/MemLeak/"

module(..., Framework.constants)
oo.class(_M, Applet)


----------------------------------------------------------------------------------------
-- Helper Functions
--

function openScreensaver(self)
	self.images = {}

	self.window = Window("window")
	self.window:setSkin(self:_getSkin())
	self.window:reSkin()
	self.canvas = Canvas('debug_canvas',function(screen)
			self:_reDrawCanvas(screen)
		end)

	local canvasItems = {
		canvas = self.canvas
	}
	local canvasGroup = Group("canvas",canvasItems)

	self.window:addWidget(canvasGroup)
	self.positionx = 0
	self.canvas:addAnimation(
		function()
			self:_refresh()
		end,
		FRAME_RATE
	)
	local manager = appletManager:getAppletInstance("ScreenSavers")
	manager:screensaverWindow(self.window)

	-- Show the window
	self.window:show(Window.transitionFadeIn)
end

function _refresh(self)
	self.positionx=self.positionx+1
	if self.positionx>480 then
		self.positionx = 0
		collectgarbage()
	end
	self.canvas:reSkin()
end

function _reDrawCanvas(self,screen)
	local i=0
	while i<5 do
		self:_drawArtwork(screen,0.9,0.9,self.positionx+(i*10),0)
		i=i+1
	end
end

function _drawArtwork(self,screen,zoomx,zoomy,positionx,positiony)
	local tmp = self:_loadImage("album.png"):zoom(zoomx,zoomy,1)
	tmp:blit(screen,positionx,positiony)
	tmp:release()
end

function _loadImage(self,file)
	if not self.images[file] then
		self.images[file] = Surface:loadImage(IMG_PATH .. file)
	end
	return self.images[file]
end

function _getSkin(self)
	local s = {}
	s.window = {
		bgImg= Tile:fillColor(0x000000ff),
		canvas = {
			zOrder = 2,
		},
	}
	return s
end

--[[

=head1 LICENSE

Copyright (C) 2009 Erland Isaksson (erland_i@hotmail.com)

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
   
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.
    
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA

=cut
--]]


