#!/bin/sh

# Stop jive application
/etc/init.d/squeezeplay stopwdog

# Some preparation
cd /lib/atheros
export WORKAREA=/lib/atheros
export EEPROM=${WORKAREA}/calData_ar6102_15dBm.bin

# Unload regular wireless driver
./loadAR6000l.sh unloadall

# Load test wireless driver
./loadtestcmdl.sh

echo

# Sample command (turn on)
echo 'Sample command (turn on)'
echo './athtestcmd -i eth1 --tx sine --txfreq 1 --txpwr 15'
echo

# Sample command (turn off)
echo 'Sample command (turn on)'
echo './athtestcmd -i eth1 --tx off --txfreq 1 --txpwr 15'
echo

# General help
echo 'For more options type:'
echo './athtestcmd'
echo


