# Plugins::MusicInfoSCR::Web.pm by mh 2006/7
#
# This code is derived from code with the following copyright message:
#
# SliMP3 Server Copyright (C) 2001 Sean Adams, Slim Devices Inc.
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License,
# version 2.

use strict;

package Plugins::MusicInfoSCR::Web;

sub handlePreview {
	my ($client, $params) = @_;

	my @prefixes = (
		'plugin_musicinfo_centerA',
		'plugin_musicinfo_lineA',
		'plugin_musicinfo_overlayA',
		'plugin_musicinfo_centerB',
		'plugin_musicinfo_lineB',
		'plugin_musicinfo_overlayB',
		'plugin_musicinfo_center_dbl',
		'plugin_musicinfo_line_dbl',
		'plugin_musicinfo_overlay_dbl'
	);

	my @postfixes = ( '', '_P', '_X', '_2X', '_PX' );

	if (defined $params->{'live'} && $params->{'live'} && Slim::Player::Playlist::count($client) > 0) {
		my $songIndex = Slim::Player::Source::playingSongIndex($client);
		my $song = Slim::Player::Playlist::song($client, $songIndex);
	
		foreach my $prefix (@prefixes) {
			$params->{$prefix} = Plugins::MusicInfoSCR::Info::getFormatString($client, $params->{$prefix}, $song, $songIndex);
			$params->{$prefix . '_size'} = Plugins::MusicInfoSCR::Info::getFormatString($client, $params->{$prefix . '_size'} , $song, $songIndex);

			if ($params->{$prefix} =~ /(PLAYTIME|PROGRESSBAR)/) {
				$params->{$prefix} =~ s/PLAYTIME_PROGRESS/PROGRESSBAR PLAYTIME/sig;
				$params->{$prefix} =~ s/PROGRESSBAR/\(=====\)/sig;
				$params->{$prefix} = Plugins::MusicInfoSCR::Info::getPlayTime($client, $params->{$prefix}, '', 1, 1);
			}		
		}
	}
	
	return Slim::Web::HTTP::filltemplatefile('plugins/MusicInfoSCR/settings/preview.html', $params);
}

1;
