# 				BrowseByTags plugin 
#
#    Copyright (c) 2008 Erland Isaksson (erland_i@hotmail.com)
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Plugins::PostScanner::Plugin;

use strict;

use base qw(Slim::Plugin::Base);

use Slim::Utils::Prefs;
use Slim::Buttons::Home;
use Slim::Utils::Misc;
use Slim::Utils::Strings qw(string);
use Slim::Utils::Log;
use Plugins::PostScanner::Importer;

my @pluginDirs = ();
our $PLUGINVERSION =  undef;

my $prefs = preferences('plugin.browsebytags');
my $serverPrefs = preferences('server');
my $log = Slim::Utils::Log->addLogCategory({
	'category'     => 'plugin.browsebytags',
	'defaultLevel' => 'WARN',
	'description'  => 'PLUGIN_BROWSEBYTAGS',
});

sub getDisplayName {
	return 'PLUGIN_BROWSEBYTAGS';
}

sub initPlugin {
	my $class = shift;
	$class->SUPER::initPlugin(@_);
	$PLUGINVERSION = Slim::Utils::PluginManager->dataForPlugin($class)->{'version'};
	Slim::Music::Import->addImporter('Plugins::PostScanner::Scanner', {
		'postScan'	=> 1,
		'use'		=> 1,
		'weight'	=> 80,
	});
	Slim::Schema->registerTrackPostScanner("Plugins::PostScanner::Plugin",{
		'weight' => 30,
		'func' => \&Plugins::PostScanner::Importer::trackUpdated,
	});
	Slim::Schema->registerGenrePostScanner("Plugins::PostScanner::Plugin",{
		'weight' => 30,
		'func' => \&Plugins::PostScanner::Importer::genreUpdated,
	});
	Slim::Schema->registerContributorPostScanner("Plugins::PostScanner::Plugin",{
		'weight' => 30,
		'func' => \&Plugins::PostScanner::Importer::contributorUpdated,
	});
	Slim::Schema->registerAlbumPostScanner("Plugins::PostScanner::Plugin",{
		'weight' => 30,
		'func' => \&Plugins::PostScanner::Importer::albumUpdated,
	});

}

sub getFunctions {
	return {}
}

1;

__END__
