# 				Post Scanner plugin 
#
#    Copyright (c) 2008 Erland Isaksson (erland_i@hotmail.com)
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Plugins::PostScanner::Importer;

use strict;

use base qw(Slim::Plugin::Base);

use Slim::Utils::Prefs;
use Slim::Buttons::Home;
use Slim::Utils::Misc;
use Slim::Utils::Strings qw(string);
use Slim::Utils::Log;
use Plugins::PostScanner::Scanner;

my @pluginDirs = ();
our $PLUGINVERSION =  undef;

my $prefs = preferences('plugin.postscanner');
my $serverPrefs = preferences('server');
my $log = Slim::Utils::Log->addLogCategory({
	'category'     => 'plugin.postscanner',
	'defaultLevel' => 'WARN',
	'description'  => 'PLUGIN_POSTSCANNER',
});

sub getDisplayName {
	return 'PLUGIN_POSTSCANNER';
}

sub initPlugin {
	my $class = shift;
	$class->SUPER::initPlugin(@_);
	$PLUGINVERSION = Slim::Utils::PluginManager->dataForPlugin($class)->{'version'};
	Slim::Music::Import->addImporter('Plugins::PostScanner::Scanner', {
		'postScan'	=> 1,
		'use'		=> 1,
		'weight'	=> 80,
	});
	Slim::Schema->registerTrackPostScanner("Plugins::PostScanner::Plugin",{
		'weight' => 30,
		'func' => \&trackUpdated,
	});
	Slim::Schema->registerGenrePostScanner("Plugins::PostScanner::Plugin",{
		'weight' => 30,
		'func' => \&genreUpdated,
	});
	Slim::Schema->registerContributorPostScanner("Plugins::PostScanner::Plugin",{
		'weight' => 30,
		'func' => \&contributorUpdated,
	});
	Slim::Schema->registerAlbumPostScanner("Plugins::PostScanner::Plugin",{
		'weight' => 30,
		'func' => \&albumUpdated,
	});
}


sub getFunctions {
	return {}
}

sub trackUpdated {
	my $track = shift;

	$log->debug("Updating track ".$track->title);
	my $titlesort = reverse $track->titlesort;
	$track->set_column('titlesort' => $titlesort);
	$track->update();
}

sub genreUpdated {
	my $genre = shift;

	$log->debug("Updating genre ".$genre->name);
	my $namesort = reverse $genre->namesort;
	$genre->set_column('namesort' => $namesort);
	$genre->update();
}

sub contributorUpdated {
	my $contributor = shift;

	$log->debug("Updating contributor ".$contributor->name);
	my $namesort = reverse $contributor->namesort;
	$contributor->set_column('namesort' => $namesort);
	$contributor->update();
}

sub albumUpdated {
	my $album = shift;

	$log->debug("Updating album ".$album->title);
	my $titlesort = reverse $album->titlesort;
	$album->set_column('titlesort' => $titlesort);
	$album->update();
}

1;

__END__
