# 				Post Scanner plugin 
#
#    Copyright (c) 2008 Erland Isaksson (erland_i@hotmail.com)
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Plugins::PostScanner::Scanner;

use strict;

use base qw(Slim::Plugin::Base);

use Slim::Utils::Prefs;
use Slim::Buttons::Home;
use Slim::Utils::Misc;
use Slim::Utils::Strings qw(string);
use Slim::Utils::Log;

my @pluginDirs = ();
our $PLUGINVERSION =  undef;

my $prefs = preferences('plugin.postscanner');
my $serverPrefs = preferences('server');
my $log = Slim::Utils::Log->addLogCategory({
	'category'     => 'plugin.postscanner',
	'defaultLevel' => 'WARN',
	'description'  => 'PLUGIN_POSTSCANNER',
});

sub startScan {
	my $contributors = Slim::Schema->resultset('Contributor')->search(
		{'contributorTracks.role' => {'in' => [1,5]}},
		{
			'group_by' => 'me.id',
			'join' => qw(contributorTracks),
		}
	);
	my $count = $contributors->count;
	my $progress = Slim::Utils::Progress->new({
		'type' => 'importer',
		'name' => 'PLUGIN_POSTSCANNER',
		'total' => $count,
		'bar'	=> 1,
	});
	# Stupid sleep for 10 seconds so we are able to see the progressbar
	sleep(10);
	my $contributor = $contributors->next;
	while($contributor) {
		$progress->update;
		if($contributor->name !~ /^Artist /) {
			# Lets add "Artist" in the beginning of the artist name to make sure the scanner result is showed somehow.
			$contributor->set_column('name' => 'Artist '.$contributor->name);
			$contributor->update;
		}
		$contributor = $contributors->next;
	}
	# Stupid sleep for 10 seconds so we are able to see the progressbar
	sleep(10);
	$progress->final($count);
}

1;

__END__
