# 				BrowseByTags plugin 
#
#    Copyright (c) 2008 Erland Isaksson (erland_i@hotmail.com)
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package Plugins::BrowseByTags::Plugin;

use strict;

use base qw(Slim::Plugin::Base);

use Slim::Utils::Prefs;
use Slim::Buttons::Home;
use Slim::Utils::Misc;
use Slim::Utils::Strings qw(string);
use Slim::Utils::Log;
use File::Spec::Functions qw(:ALL);
use DBI qw(:sql_types);
use FindBin qw($Bin);
use Plugins::BrowseByTags::Template::Reader;

my @pluginDirs = ();
our $PLUGINVERSION =  undef;

my $prefs = preferences('plugin.browsebytags');
my $serverPrefs = preferences('server');
my $log = Slim::Utils::Log->addLogCategory({
	'category'     => 'plugin.browsebytags',
	'defaultLevel' => 'WARN',
	'description'  => 'PLUGIN_BROWSEBYTAGS',
});

sub getDisplayName {
	return 'PLUGIN_BROWSEBYTAGS';
}

sub initPlugin {
	my $class = shift;
	$class->SUPER::initPlugin(@_);
	$PLUGINVERSION = Slim::Utils::PluginManager->dataForPlugin($class)->{'version'};
}


sub getFunctions {
	return {}
}

sub getCustomBrowseMenus {
	my $client = shift;
	return Plugins::BrowseByTags::Template::Reader::getTemplates($client,'BrowseByTags',$PLUGINVERSION,'FileCache/CustomBrowse','Menus','xml','template','menu','simple',1);
}
sub getCustomBrowseTemplates {
	my $client = shift;
	return Plugins::BrowseByTags::Template::Reader::getTemplates($client,'BrowseByTags',$PLUGINVERSION,'FileCache/CustomBrowse','MenuTemplates','xml');
}

sub getCustomBrowseMenuData {
	my $client = shift;
	my $templateItem = shift;
	my $parameterValues = shift;
	my $data = Plugins::BrowseByTags::Template::Reader::readTemplateData('BrowseByTags','Menus',$templateItem->{'id'},"xml");
	return $data;
}

sub getCustomBrowseTemplateData {
	my $client = shift;
	my $templateItem = shift;
	my $parameterValues = shift;
	
	my $data = Plugins::BrowseByTags::Template::Reader::readTemplateData('BrowseByTags','MenuTemplates',$templateItem->{'id'});
	return $data;
}

sub getFriendlyNameForTagList {
	my $self = shift;
	my $client = shift;
	my $item = shift;

	return ucfirst(lc($item->{'itemid'})).'s';
}
sub getFriendlyNameForTag {
	my $self = shift;
	my $client = shift;
	my $item = shift;

	my $name = getFriendlyNameByTagName($item->{'itemid'});
	if(!defined($name)) {
		return $item->{'itemid'};
	}
	return $name;
}

sub getFriendlyNameByTagName {
	my $tagName = shift;
	my $multiple = shift;

	if($multiple) {
		return ucfirst(lc($tagName)).'s';
	}else {
		return ucfirst(lc($tagName));
	}
}


sub quoteValue {
	my $value = shift;
	if(defined($value)) {
		$value =~ s/\\/\\\\/g;
		$value =~ s/\"/\\\"/g;
		$value =~ s/\'/\\\'/g;
	}
	return $value;
}
sub getTagMenuItems {
	my $self = shift;
	my $client = shift;
	my $parameters = shift;

	my $tags = $parameters->{'usedtags'};
	my $supportedTags = undef;
	if(defined($tags)) {
		my @tagArray = split(/\,/,$tags);
		for my $tag (@tagArray) {
			my $value = undef;
			if($tag =~ /^(.*)?\(.*\)$/) {
				$tag = $1;
				$value = $1;
			}
			$tag = uc($tag);
			if(defined($supportedTags)) {
				$supportedTags .= ",";
			}else {
				$supportedTags = "";
			}
			$supportedTags .= "'".quoteValue($tag)."'";
		}
	}
	my @items = ();
	my $currentTag = undef;
	my $currentValue = undef;
	if(defined($parameters)) {
		for my $p (keys %$parameters) {
			if($p =~ /^level(\d+)_(.+)$/) {
				my %filterItem = (
					'id' => $1,
					'tag' => $2,
					'value' => $parameters->{$p}
				);
				push @items,\%filterItem;
			}elsif($p =~ /^level(\d+)$/) {
				my %filterItem = (
					'id' => $1,
					'tag' => $parameters->{$p},
					'value' => undef
				);
				push @items,\%filterItem;
			}
		}
	}
	@items = sort {return $a->{'id'} <=> $b->{'id'}} @items;

	my %selectedValues = ();
	my $selectedTags = undef;
	for my $it (@items) {
		if(defined($it->{'value'})) {
			if(!defined($selectedValues{$it->{'tag'}})) {
				$selectedValues{$it->{'tag'}} = '';
			}else {
				$selectedValues{$it->{'tag'}} .= ',';
			}
			$selectedValues{$it->{'tag'}} .= "'".quoteValue($it->{'value'})."'";
			if(defined($selectedTags)) {
				$selectedTags .= ",";
			}else {
				$selectedTags = "";
			}
			$selectedTags .= "'".quoteValue($it->{'tag'})."'";
		}
	}

	my $currentLevel = scalar(@items)+1;
	my $currentItem = pop @items;
	my $levelTag = undef;
	if(defined($currentItem) && !defined($currentItem->{'value'})) {
		$currentTag = $currentItem->{'tag'};
	}elsif(defined($currentItem)) {
		$levelTag = $currentItem->{'tag'};
	}

	my $tagssql = undef;
	my $pathsql = undef;
	if(defined($currentTag)) {
		$tagssql = "select tags.reference,tags.value,substr(ifnull(tags.valuesort,tags.value),1,1),case tags.referencetype when 1 then 'artist' when 2 then 'album' when 3 then 'genre' when 4 then 'year' else null end from tags join tag_track on tags.id=tag_track.tag ";
		for my $it (@items) {
			if(defined($it->{'value'})) {
				my $attr = "attr".$it->{'id'};
				$tagssql .= "join tags $attr on $attr.name='".quoteValue($it->{'tag'})."' and $attr.reference='".quoteValue($it->{'value'})."' join tag_track join$attr on $attr.id=join$attr.tag and tag_track.track=join$attr.track ";
			}
		}
		$tagssql .= " where tags.name='".quoteValue($currentTag)."'";
		$pathsql = "select distinct tags.reference,tags.value,substr(ifnull(tags.valuesort,tags.value),1,1),case tags.referencetype when 1 then 'artist' when 2 then 'album' when 3 then 'genre' when 4 then 'year' else null end from tags join tag_track on tags.id=tag_track.tag where tags.name='".quoteValue($currentTag)."' and tags.reference='\{context.itemid\}'";
		if(defined($selectedValues{$currentTag})) {
			my $values = $selectedValues{$currentTag};
			$tagssql .=" and tags.reference not in ($values)";
		}
		if(defined($parameters->{'track'}) && !defined($selectedTags)) {
			$tagssql .=" and tag_track.track=".$parameters->{'track'};
		}
		$tagssql .=" group by tags.reference order by ifnull(tags.valuesort,tags.value)";
	}
	my $customtagpathsql=undef;

	my $taggroupssql = undef;
	my $trackssql = undef;
	my $albumssql = undef;
	my $albumssqlbyartists = undef;
	my $albumssqlbyyear = undef;
	if(!defined($currentTag)) {
		$taggroupssql = "select tags.name,tags.name,substr(tags.name,1,1) from tags join tag_track on tags.id=tag_track.tag ";
		if(scalar(@items)==0 && !defined($currentItem)) {
#			$taggroupssql .= "use index (attr_module_idx) "; 
		}
		my $i = 1;
		for my $it (@items) {
			if(defined($it->{'value'})) {
				$taggroupssql .= "join tags attr$i on attr$i.name='".quoteValue($it->{'tag'})."' and attr$i.reference='".quoteValue($it->{'value'})."' join tag_track attrjoin$i on attr$i.id=attrjoin$i.tag and tag_track.track=attrjoin$i.track ";
				$i++;
			}
		}
		if(defined($currentItem)) {
			$taggroupssql .= "join tags currentattr on currentattr.name='".quoteValue($currentItem->{'tag'})."' and currentattr.reference='".quoteValue($currentItem->{'value'})."' join tag_track currentattrjoin on currentattr.id=currentattrjoin.tag and tag_track.track=currentattrjoin.track ";
		}
		my $whereAdded = 0;
		if(scalar(keys %selectedValues)>0) {
			$taggroupssql .= " where ";
			$whereAdded = 1;
			my $subquery = undef;
			for my $key (keys %selectedValues) {
				my $values = $selectedValues{$key};
				if(defined($subquery)) {
					$subquery .= " or ";
				}else {
					$subquery = "(";
				}
				$subquery .= "(tags.name='".quoteValue($key)."' and tags.reference not in ($values))";
			}
			$taggroupssql .= "$subquery or tags.name not in ($selectedTags)) ";
		}
		if(defined($supportedTags)) {
			if(!$whereAdded) {
				$taggroupssql .= " where ";
				$whereAdded = 1;
				$taggroupssql .=" tags.name in ($supportedTags) ";
			}else {
				$taggroupssql .=" and tags.name in ($supportedTags) ";
			}
		}
		if(defined($parameters->{'track'}) && !defined($selectedTags)) {
			if(!$whereAdded) {
				$taggroupssql .= " where ";
				$whereAdded = 1;
				$taggroupssql .=" tags.name=".$parameters->{'track'}." ";
			}else {
				$taggroupssql .=" and tags.name=".$parameters->{'track'}." ";
			}
		}
		$taggroupssql .= "group by tags.name order by tags.name";
	}

	# Create All songs SQL
	$trackssql = "select tracks.id,tracks.title,substr(tracks.titlesort,1,1) from tracks ";
	for my $it (@items) {
		if(defined($it->{'value'})) {
			my $attr = "attr".$it->{'id'};
			$trackssql .= "join tags $attr on $attr.name='".quoteValue($it->{'tag'})."' and $attr.reference='".quoteValue($it->{'value'})."' join tag_track join$attr on join$attr.tag=$attr.id and tracks.id=join$attr.track ";
		}
	}
	if(defined($currentItem->{'value'})) {
		$trackssql .= "join tags on tags.name='".quoteValue($currentItem->{'tag'})."' and tags.reference='".quoteValue($currentItem->{'value'})."' join tag_track on tags.id=tag_track.tag and tracks.id=tag_track.track";
	}
	$trackssql .= " where tracks.audio=1";
	$trackssql .=" group by tracks.id order by tracks.album,tracks.disc,tracks.tracknum";

	if(defined($currentItem)) {

		if(!defined($parameters->{'findalbums'}) || $parameters->{'findalbums'} ne '0') {
			# Create All albums SQL
			my $roles = "1,5";
			if(defined($parameters->{'roles'}) && $parameters->{'roles'}) {
				$roles = $parameters->{'roles'};
			}
			$albumssqlbyartists = "select albums.id,ifnull(if(albums.compilation,' ',concat('(', group_concat(distinct contributors.name separator ',') ,')')),' '),substr(albums.titlesort,1,1),'album' from albums join tracks on tracks.album=albums.id ";
			$albumssqlbyartists .= "left join contributor_track on contributor_track.track=tracks.id and contributor_track.role in ($roles) ";
			$albumssqlbyartists .= "left join contributors on contributor_track.contributor=contributors.id ";

			if(defined($parameters->{'showartistwithalbum'}) && $parameters->{'showartistwithalbum'}) {
				$albumssql = "select albums.id,ifnull(if(albums.compilation,' ',concat('(', group_concat(distinct contributors.name separator ',') ,')')),' '),substr(albums.titlesort,1,1),'album' from albums join tracks on tracks.album=albums.id ";
				$albumssql .= "left join contributor_track on contributor_track.track=tracks.id and contributor_track.role in ($roles) ";
				$albumssql .= "left join contributors on contributor_track.contributor=contributors.id ";

				$albumssqlbyyear = "select albums.id,if(albums.compilation,if(albums.year=0,' ',concat('(',albums.year,')')),concat(if(albums.year=0,'(',concat('(',albums.year,' ')), ifnull(group_concat(distinct contributors.name separator ','),'') ,')')),substr(albums.titlesort,1,1),'album' from albums join tracks on tracks.album=albums.id ";
				$albumssqlbyyear .= "left join contributor_track on contributor_track.track=tracks.id and contributor_track.role in ($roles) ";
				$albumssqlbyyear .= "left join contributors on contributor_track.contributor=contributors.id ";
			}else {
				$albumssql = "select albums.id,albums.title,substr(albums.titlesort,1,1),'album' from albums join tracks on tracks.album=albums.id ";
				$albumssqlbyyear = "select albums.id,if(albums.year=0,' ',concat('(',albums.year,')')),substr(albums.titlesort,1,1),'album' from albums join tracks on tracks.album=albums.id ";
			}
			my $commonsql = '';
			for my $it (@items) {
				if(defined($it->{'value'})) {
					my $attr = "attr".$it->{'id'};
					$commonsql .= "join tags $attr on $attr.name='".quoteValue($it->{'tag'})."' and $attr.reference='".quoteValue($it->{'value'})."' join tag_track join$attr on $attr.id=join$attr.tag and tracks.id=join$attr.track ";
				}
			}
			if(defined($currentItem->{'value'})) {
				$commonsql .= "join tags on tags.name='".quoteValue($currentItem->{'tag'})."' and tags.reference='".quoteValue($currentItem->{'value'})."' join tag_track on tags.id=tag_track.tag and tracks.id=tag_track.track";
			}
			$albumssql .= $commonsql." where tracks.audio=1";
			$albumssql .=" group by albums.id order by albums.titlesort,albums.disc";
			$albumssqlbyyear .= $commonsql." where tracks.audio=1";
			$albumssqlbyyear .=" group by albums.id order by albums.year desc,albums.titlesort,albums.disc";
			$albumssqlbyartists .= $commonsql." where tracks.audio=1";
			$albumssqlbyartists .=" group by albums.id order by contributors.namesort,albums.titlesort,albums.disc";
		}
	}
	
	my @menus = ();
	if(defined($taggroupssql)) {
		my %menu = (
			'id' => 'level'.$currentLevel,
			'playtype' => 'none',
			'menutype' => 'sql',
			'menudata' => $taggroupssql,
			'menulinks' => 'alpha',
			'playtypeall' => 'none',
			'itemformat' => 'function',
			'itemformatdata' => 'Plugins::BrowseByTags::Plugin::getFriendlyNameForTagList',
			'menufunction' => 'Plugins::BrowseByTags::Plugin::getTagMenuItems'
		);
		if(defined($parameters->{'shortpath'}) && $parameters->{'shortpath'}) {
			$menu{'pathtype'} = 'none';
		};
		if(defined($levelTag)) {
			my $menuName = Plugins::BrowseByTags::Plugin::getFriendlyNameByTagName($levelTag);
			if(!defined($menuName)) {
				$menuName = $levelTag;
			}
			$menu{'menuname'} = $menuName;
		}
		if(defined($parameters->{'track'}) && !defined($selectedTags)) {
			$menu{'menufunction'} .= "|track=".$parameters->{'track'};
		}
		if(defined($parameters->{'usedtags'})) {
			$menu{'menufunction'} .= "|usedtags=".$parameters->{'usedtags'};
		}
		if(defined($parameters->{'findtracks'})) {
			$menu{'menufunction'} .= "|findtracks=".$parameters->{'findtracks'};
		}
		if(defined($parameters->{'findalbums'})) {
			$menu{'menufunction'} .= "|findalbums=".$parameters->{'findalbums'};
		}
		if(defined($parameters->{'playalltracks'})) {
			$menu{'menufunction'} .= "|playalltracks=".$parameters->{'playalltracks'};
		}
		if(defined($parameters->{'shortpath'})) {
			$menu{'menufunction'} .= "|shortpath=".$parameters->{'shortpath'};
		}
		if(defined($parameters->{'showalbumsafterlevel'})) {
			$menu{'menufunction'} .= "|showalbumsafterlevel=".$parameters->{'showalbumsafterlevel'};
		}
		if(defined($parameters->{'showtracksafterlevel'})) {
			$menu{'menufunction'} .= "|showtracksafterlevel=".$parameters->{'showtracksafterlevel'};
		}
		if(defined($parameters->{'showcustomtagsafterlevel'})) {
			$menu{'menufunction'} .= "|showcustomtagsafterlevel=".$parameters->{'showcustomtagsafterlevel'};
		}
		if(defined($parameters->{'showartistwithalbum'})) {
			$menu{'menufunction'} .= "|showartistwithalbum=".$parameters->{'showartistwithalbum'};
		}		
		if(defined($parameters->{'roles'})) {
			$menu{'menufunction'} .= "|roles=".$parameters->{'roles'};
		}		
		if(defined($parameters->{'defaultalbumsort'})) {
			$menu{'menufunction'} .= "|defaultalbumsort=".$parameters->{'defaultalbumsort'};
		}		

		push @menus,\%menu;
	}

	if(defined($tagssql)) {
		my $menuName = Plugins::BrowseByTags::Plugin::getFriendlyNameByTagName($currentTag,1);
		if(!defined($menuName)) {
			$menuName = Plugins::BrowseByTags::Plugin::getFriendlyNameByTagName($currentTag);
			if(!defined($menuName)) {
				$menuName = $currentTag;
			}
			$menuName .= "s";
		}
		my %menu = (
			'id' => 'level'.$currentLevel."_".$currentTag,
			'menuname' => $menuName,
			'menulinks' => 'alpha',
			'pathtype' => 'sql',
			'pathtypedata' => $pathsql,
			'menutype' => 'sql',
			'menudata' => $tagssql,
			'itemtype' => 'sql',
			'playtypeall' => 'none',
			'menufunction' => 'Plugins::BrowseByTags::Plugin::getTagMenuItems'
		);
		if(defined($trackssql)) {
			$menu{'playtype'} = 'sql';
			$menu{'playdata'} = $trackssql;
		}
		if(defined($parameters->{'track'}) && !defined($selectedTags)) {
			$menu{'menufunction'} .= "|track=".$parameters->{'track'};
		}
		if(defined($parameters->{'usedtags'})) {
			$menu{'menufunction'} .= "|usedtags=".$parameters->{'usedtags'};
		}
		if(defined($parameters->{'findtracks'})) {
			$menu{'menufunction'} .= "|findtracks=".$parameters->{'findtracks'};
		}
		if(defined($parameters->{'findalbums'})) {
			$menu{'menufunction'} .= "|findalbums=".$parameters->{'findalbums'};
		}
		if(defined($parameters->{'playalltracks'})) {
			$menu{'menufunction'} .= "|playalltracks=".$parameters->{'playalltracks'};
		}
		if(defined($parameters->{'shortpath'})) {
			$menu{'menufunction'} .= "|shortpath=".$parameters->{'shortpath'};
		}
		if(defined($parameters->{'showalbumsafterlevel'})) {
			$menu{'menufunction'} .= "|showalbumsafterlevel=".$parameters->{'showalbumsafterlevel'};
		}
		if(defined($parameters->{'showtracksafterlevel'})) {
			$menu{'menufunction'} .= "|showtracksafterlevel=".$parameters->{'showtracksafterlevel'};
		}
		if(defined($parameters->{'showcustomtagsafterlevel'})) {
			$menu{'menufunction'} .= "|showcustomtagsafterlevel=".$parameters->{'showcustomtagsafterlevel'};
		}
		if(defined($parameters->{'showartistwithalbum'})) {
			$menu{'menufunction'} .= "|showartistwithalbum=".$parameters->{'showartistwithalbum'};
		}		
		if(defined($parameters->{'roles'})) {
			$menu{'menufunction'} .= "|roles=".$parameters->{'roles'};
		}		
		if(defined($parameters->{'defaultalbumsort'})) {
			$menu{'menufunction'} .= "|defaultalbumsort=".$parameters->{'defaultalbumsort'};
		}		
		
		push @menus,\%menu;
	}

	my $directalbums = undef;
	if(defined($albumssql) && scalar(keys %selectedValues)>0 && defined($taggroupssql)) {
		my %trackDetails = (
			'id' => 'trackdetails',
			'menuname' => 'Song',
			'menutype' => 'trackdetails',
			'menudata' => 'track|0'
		);
		my $sql = "select tracks.id,tracks.title from tracks ";
		$sql .= " where tracks.audio=1 and tracks.album=\{album\} group by tracks.id order by tracks.disc,tracks.tracknum";
		my %menutracks = (
			'id' => 'track',
			'menuname' => 'Songs',
			'itemformat' => "track",
			'itemtype' => "track",
			'menutype' => 'sql',
			'menudata' => $sql,
			'menu' => \%trackDetails
		);

		if(!defined($parameters->{'playalltracks'}) || $parameters->{'playalltracks'} ne '0') {
			$menutracks{'playtype'} = 'all';
		}
		my %menualbums = (
			'id' => 'album',
			'menuname' => 'Albums',
			'menulinks' => 'alpha',
			'itemformat' => "album",
			'itemtype' => "album",
			'menutype' => 'sql',
			'menudata' => $albumssql,
			'menu' => \%menutracks
		);
		if(defined($parameters->{'showartistwithalbum'}) && $parameters->{'showartistwithalbum'}) {
			$menualbums{'itemformat'} = 'albumconcat';
		}
		if(defined($parameters->{'defaultalbumsort'}) && $parameters->{'defaultalbumsort'}) {
			$menualbums{'defaultoption'} = $parameters->{'defaultalbumsort'};
		}
		my %menualbumsbytitle = (
			'id' => 'bytitle',
			'name' => 'Sort by title',
			'menulinks' => 'alpha',
		);
		my %menualbumsbyyear = (
			'id' => 'byyear',
			'name' => 'Sort by year',
			'itemformat' => 'albumconcat',
			'menulinks' => 'number',
			'menudata' => $albumssqlbyyear,
		);
		my %menualbumsbyartists = (
			'id' => 'byartist',
			'name' => 'Sort by artist',
			'itemformat' => 'albumconcat',
			'menulinks' => 'number',
			'menudata' => $albumssqlbyartists,
		);
		my @options = ();
		push @options, \%menualbumsbytitle;
		push @options, \%menualbumsbyyear;
		push @options, \%menualbumsbyartists;
		$menualbums{'option'} = \@options;

		my %allalbums = (
			'id' => 'matchingalbums',
			'playtypeall' => 'none',
			'playtype' => 'sql',
			'playdata' => $albumssql,
			'menuname' => string('PLUGIN_BROWSEBYTAGS_MATCHING_ALBUMS'),
			'menu' => \%menualbums
		);
		if(defined($parameters->{'showalbumsafterlevel'}) && $parameters->{'showalbumsafterlevel'} ne '' && $parameters->{'showalbumsafterlevel'}<=$currentLevel) {
			$directalbums = \%menualbums;
		}else {
			push @menus,\%allalbums;
		}
	}
	my $directcustomtags = undef;

	my $directtracks = undef;
	if(defined($trackssql) && (!defined($parameters->{'findtracks'}) || $parameters->{'findtracks'} ne '0') && scalar(keys %selectedValues)>0 && defined($taggroupssql)) {
		my %trackDetails = (
			'id' => 'trackdetails',
			'menuname' => 'Song',
			'menutype' => 'trackdetails',
			'menudata' => 'track|0'
		);
		my %menutracks = (
			'id' => 'track',
			'menuname' => 'Songs',
			'itemformat' => "track",
			'itemtype' => 'track',
			'menutype' => 'sql',
			'menudata' => $trackssql,
			'menu' => \%trackDetails
		);
		if(!defined($parameters->{'playalltracks'}) || $parameters->{'playalltracks'} ne '0') {
			$menutracks{'playtype'} = 'all';
		}
		my %alltracks = (
			'id' => 'matchingsongs',
			'menuname' => string('PLUGIN_BROWSEBYTAGS_MATCHING_SONGS'),
			'playtypeall' => 'none',
			'playtype' => 'sql',
			'playdata' => $trackssql,
			'menu' => \%menutracks
		);
		if(defined($parameters->{'showtracksafterlevel'}) && $parameters->{'showtracksafterlevel'} ne '' && $parameters->{'showtracksafterlevel'}<=$currentLevel) {
			$directtracks = \%menutracks;
		}else {
			push @menus,\%alltracks;
		}
	}
	if(defined($directalbums)) {
		push @menus,$directalbums;
	}
	if(defined($directcustomtags)) {
		push @menus,$directcustomtags;
	}
	if(defined($directtracks)) {
		push @menus,$directtracks
	}

	if(scalar(@menus)>1) {
		return \@menus;
	}else {
		my $result = \@menus;
		return $result->[0];
	}
}

1;

__END__
