#include "common.h"
#include "jive.h"

int jiveL_testimage (lua_State *L) {

	/* stack is:
		 1: surface
	*/

	JiveSurface *srf = tolua_tousertype(L, 1, 0);
	SDL_Surface *sdl = srf->sdl;
	Uint32 x, y, val, *pixel;

	pixel = sdl->pixels;

	for (y = 0; y < sdl->h; y++) {
		for (x = 0; x < sdl->w; x++) {
			if (x % (sdl->w/4) < 10) {
				val = y & 0x4 ? 0xffffffff : 0xff000000;
			} else {
				switch (4 * x / sdl->w) {
				case 0:
					val = y << 16;
					break;
				case 1:
					val = y <<  8; 
					break;
				case 2:
					val = y <<  0;
					break;
				case 3:
					val = y | y << 8 | y << 16;
				}
			}
			*pixel++ = 0xff000000 | val;
		}
	}

	return 0;
}


static const struct luaL_Reg testlib [] = {
	{ "testimage", jiveL_testimage },
 	{ NULL, NULL }
};


int luaopen_applets_DisplayTest_test (lua_State *L) {
	luaL_register(L, "test", testlib);
	return 1;
}
