Main = {
	background : Ext.get('background'),
	body : Ext.get(document.body),
	layout : null,

	init : function(){
		Ext.UpdateManager.defaults.indicatorText = '<div class="loading-indicator">' + SqueezeJS.string('loading') + '</div>';
//		Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

		var leftpanel = {
			region: 'center',
			_region: 'left',
			layout: 'border',
			items: [
				{
					region: 'north',
					contentEl: 'leftheader',
					border: false,
					height: 12
				},
				{
					region: 'center',
					border: false,
					contentEl: 'leftcontent'
				},
				{
					region: 'south',
					contentEl: 'leftfooter',
					border: false,
					height: 12
				}
			],
			border: false,
			split: true,
			minSize: 200,
			width: '50%'
		};

		var rightpanel = {
			region: 'east',
			_region: 'right',
			layout: 'border',
			items: [
				{
					region: 'north',
					contentEl: 'rightheader',
					border: false,
					height: 12
				},
				{
					region: 'center',
					border: false,
					contentEl: 'rightcontent'
				},
				{
					region: 'south',
					contentEl: 'rightfooter',
					border: false,
					height: 12
				}
			],
			border: false,
			split: true,
			minSize: 400,
			width: '50%'
		};

		var mainpanel = {
			layout: 'border',
			border: false,
			style: 'z-index: 200;',
			renderHidden: true,
			items: [
				{
					region: 'north',
					contentEl: 'header',
					border: false,
					margins: '5 5 0 5',
					height: 40
				},
				
				{
					region: 'center',
					layout: 'border',
					border: false,
					margins: '0 15',
					items: [leftpanel, rightpanel]
				},

				{
					region: 'south',
					contentEl: 'footer',
					border: false,
					margins: '0 5 5 5',
					height: 40
				}
			]
		}

		this.layout = new Ext.Viewport(mainpanel);

		SqueezeJS.Controller.init({
			player: playerid,
			notifier : function(text){
				var info = Ext.get('footerInfoText');
				if (info) {
					info.update('<img src="' + webroot + 'html/images/btn_info.gif"/>&nbsp;' + text);
					info.fadeIn().pause(3).fadeOut();
				}
			}
		});
		this._playerControlInit();

		this.playlist = new SqueezeJS.UI.Playlist({
			renderTo: 'playlistPanel',			// the panel where the playlist will be displayed
			playlistEl: 'playList',				// the actual playlist (the panel less the navigation bar, buttons etc.)
			currentSelector: 'div.currentSong'	// selector for the current playlist item
		});

		Ext.get('loading').hide();
		Ext.get('loading-mask').hide();

		// cache the offsets we're going to use to resize the background image
		this.offsets = [
			this.background.getTop() * 2,
			this.background.getLeft() * 2
		]
		

		Ext.EventManager.onWindowResize(this.onResize, this);
		this.onResize(this.body.getWidth(), this.body.getHeight());
	},

	onResize : function(width, height) {
		this.background.setHeight(height - this.offsets[0]);
		this.background.setWidth(width - this.offsets[1]);
	},

	_playerControlInit : function(){
		new SqueezeJS.UI.Buttons.PlayerDropdown({
			renderTo: 'playerChooser'
		});

		new SqueezeJS.UI.Buttons.Rew({
			renderTo: 'ctrlPrevious',
			minWidth: 31
		});

		new SqueezeJS.UI.Buttons.Play({
			renderTo: 'ctrlTogglePlay',
			minWidth: 31
		});

		new SqueezeJS.UI.Buttons.Fwd({
			renderTo: 'ctrlNext',
			minWidth: 31
		});

		new SqueezeJS.UI.Buttons.Repeat({
			renderTo: 'ctrlRepeat',
			minWidth: 31
		});

		new SqueezeJS.UI.Buttons.Shuffle({
			renderTo: 'ctrlShuffle',
			minWidth: 31
		});

		new SqueezeJS.UI.Buttons.VolumeDown({
			renderTo: 'ctrlVolumeDown',
			minWidth: 27
		});

		new SqueezeJS.UI.Buttons.VolumeUp({
			renderTo: 'ctrlVolumeUp',
			minWidth: 27
		});

		new SqueezeJS.UI.VolumeBar({
			el: 'ctrlVolume'
		});

		new SqueezeJS.UI.Buttons.Power({
			renderTo: 'ctrlPower',
			minWidth: 24
		});

		new SqueezeJS.UI.Title('ctrlCurrentTitle');
		new SqueezeJS.UI.CompoundTitle('ctrlCurrentSongInfoCollapsed');
		new SqueezeJS.UI.Album('ctrlCurrentAlbum');
		new SqueezeJS.UI.Contributors('ctrlCurrentArtist');
		new SqueezeJS.UI.Bitrate('ctrlBitrate');
		new SqueezeJS.UI.CurrentIndex('ctrlPlayNum');
		new SqueezeJS.UI.SongCount('ctrlSongCount');
		
		new SqueezeJS.UI.Playtime('ctrlPlaytime');
		new SqueezeJS.UI.CompoundPlaytime('ctrlPlaytimeCollapsed');
		new SqueezeJS.UI.PlaytimeRemaining('ctrlRemainingTime');
		new SqueezeJS.UI.PlaytimeProgress('ctrlProgress');

		new SqueezeJS.UI.Coverart({
			el: 'ctrlCurrentArt',
			size: 96
		});

		new SqueezeJS.UI.CoverartPopup({ target: 'ctrlCurrentArt' });

		// display song information with coverart in the collapsed mode
		new SqueezeJS.UI.CoverartPopup({
			target: 'nowPlayingIcon',
			songInfo: true
		});
	}

};

