var SqueezeJS = {
	Strings : new Array(),
	string : function(s){ return this.Strings[s]; },

	contributorRoles : new Array('artist', 'composer', 'conductor', 'band', 'albumartist', 'trackartist'),
	coverFileSuffix : Ext.isIE && !Ext.isIE7 ? 'gif' : 'png',

	Controller : null
};


_init();

// Initialize SqueezeJS.Controller
// Look whether there's already a Controller running in a parent frame.
// If one does exist, only create a proxy SqueezeJS.Controller hooking to it,
// otherwise create new Controller.
function _init() {
	var p = (window == window.parent ? null : window.parent);
	while (p) {

		if (p.SqueezeJS.Controller) {
			// proxy to parent Controller
			SqueezeJS.Controller = p.SqueezeJS.Controller;
			return;
		}
	
		p = p.parent;
	}

	// no parent Controller found - create our new, own instance
	SqueezeJS.Controller = new Ext.util.Observable();
	Ext.apply(SqueezeJS.Controller, {
		player : '',
		observers : null,
	
		playerStatus : {
			power: null,
			mode: null,
			rate: 0,
			current_title: null,
			title: null,
			track: null,
			index: null,
			duration: null,
			playtime: 0,
			timestamp: null,
			dontUpdate: false,
			player: null
		},
	
		init : function(o){
			Ext.apply(this, o);

			this.events = this.events || {};
			this.addEvents({
				'playerselected': true,
				'playerlistchange': true,
				'playlistchange': true,
				'playerstatechange': true,
				'playtimeupdate': true
			})
	
			this.addObserver({
				name : 'playerstatus',
				fn : function(self){
	
					if (this.player) {
	
						this.playerRequest({
							params: [ "status", "-", 1, "tags:uB" ],
				
							// set timer
							callback: function(){
								self.timer.delay(5000);
							},
				
							success: function(response){
								if (response && response.responseText) {
									response = Ext.util.JSON.decode(response.responseText);
		
									// only continue if we got a result and player
									if (response.result && response.result.player_connected) {
										if (response.result.time)
											this.playerStatus.playtime = parseInt(response.result.time);
		
										if (response.result.duration)
											this.playerStatus.duration = parseInt(response.result.duration);
		
										// check whether we need to update our song info & playlist
										if (this._needUpdate(response.result)){
											this._getStatus();
											self.timer.delay(5000);
										}

										// display information if the player needs a firmware upgrade
										if (response.player_needs_upgrade) {
											this.fireEvent('playlistchange');
										}
									}
								}
							},
				
							scope: this
						})
					}
	
					else {
						self.timer.delay(5000);
					}
			
				}
			});
	
			this.addObserver({
				name : 'serverstatus',
				fn : function(self){
	
					this.request({
						params: [ '', [ "serverstatus", 0, 999 ] ],
			
						// set timer
						callback: function(){
							self.timer.delay(this.player ? 30000 : 10000);
						},
			
						success: function(response){
							response = Ext.util.JSON.decode(response.responseText);
							if (response && response.result) {
								this.fireEvent('playerlistchange', response.result);
							}
						},
			
						scope: this
					})
			
				}
			});
	
			this.addObserver({
				name : 'playtimeticker',
				fn : function(self){
					if (this.playerStatus.duration > 0 && this.playerStatus.playtime >= this.playerStatus.duration-1)
						this._getStatus();

					this.fireEvent('playtimeupdate', {
						current: this.playerStatus.playtime,
						duration: this.playerStatus.duration,
						remaining: this.playerStatus.duration ? parseInt(this.playerStatus.playtime) - this.playerStatus.duration : 0
					})
	
					// force 0 for current time when stopped
					if (this.playerStatus.mode == 'stop')
						this.playerStatus.playtime = 0;
	
					// only increment interim value if playing and not scanning (FWD/RWD)
					else if (this.playerStatus.mode == 'play' && this.playerStatus.rate == 1)
						this.playerStatus.playtime += 0.5;
	
					self.timer.delay(500);
				}
			});
		},

		addObserver : function(config){
			if (!this.observers)
				this.observers = new Ext.util.MixedCollection();
	
			config.timer = new Ext.util.DelayedTask(config.fn, this, [ config ]);
			config.timer.delay(0);
			this.observers.add(config.name, config);
		},
	
		updateAll : function(){
			if (this.observers){
				this.playerStatus.power = null;
				this.observers.each(function(observer){
					observer.timer.delay(0);
				});
			}
		},
	
		// different kind of requests to the server
		request : function(config){
			// shortcut for .request('http://...') calls
			if (typeof config == 'string')
				config = {
					url: config,
					method: 'GET'
				};
	
			Ext.Ajax.request({
				url: config.url || '/jsonrpc.js',
				method: config.method ? config.method : 'POST',
				params: config.url ? null : Ext.util.JSON.encode({
					id: 1,
					method: "slim.request",
					params: config.params
				}),
				timeout: config.timeout || 5000,
				callback: config.callback,
				success: config.success,
				failure: config.failure,
				scope: config.scope || this
			});
		},
	
		playerRequest : function(config){
			config.params = [
				this.player,
				config.params
			];
			this.request(config);
		},
	
		// custom playerRequest which requires a controller update
		// ussually used in player controls
		playerControl : function(action, dontUpdate){
			this.playerRequest({
				success: function(response){
					this.playerStatus.dontUpdate = dontUpdate;
					this._getStatus();
		
					if (response && response.responseText) {
						response = Ext.util.JSON.decode(response.responseText);
						if (response && response.result && response.result.text) {
							this.notifier(response.result.text);
						}
					}
				},
				params: action
			});
		},
	
		urlRequest : function(myUrl, updateStatus) {
			this.request({
				url: myUrl,
				method: 'GET',
				callback: function(){
					// try updating the player control in this or the parent document
					if (updateStatus) {
	/*					try { this.fireEvent('updatePlayerStatus'); }
						catch(e) {
							try { parent.SqueezeJS.Request.fireEvent('updatePlayerStatus'); }
							catch(e) {}
						}
	*/				}
				}
			});
		},
		
		playlistRequest : function(param, reload) {
			this.urlRequest('/status_header.html?' + param + 'ajaxRequest=1&force=1', true);
			if (reload) {
	/*			try { this.fireEvent('updatePlaylist'); }
				catch(e) {
					try { parent.SqueezeJS.Request.fireEvent('updatePlaylist'); }
					catch(e) {}
				}
	*/		}
		},
	
		notifier : function(){},
	
		_getStatus : function(){
			if (this.player) {
				this.playerRequest({
					params: [ "status", "-", 1, "tags:gABbehldiqtyrSuoKLN" ],
					failure: this._updateStatus,
					success: this._updateStatus,
					scope: this
				});
			}
		},
	
		_updateStatus : function(response) {
			if (!(response && response.responseText))
				return;
	
			response = Ext.util.JSON.decode(response.responseText);
	
			// only continue if we got a result and player
			if (!(response.result && response.result.player_connected))
				return;
	
			response = response.result;
	
			this.fireEvent('playerstatechange', response);
	
			if (this._needUpdate(response) && Ext.get('playList'))
				this.fireEvent('playlistchange', response);
	
			this.playerStatus = {
				// if power is undefined, set it to on for http clients
				power:     (response.power == null) || response.power,
				mode:      response.mode,
				rate:      response.rate,
				current_title: response.current_title,
				title:     response.playlist_tracks > 0 ? response.playlist_loop[0].title : '',
				track:     response.playlist_tracks > 0 ? response.playlist_loop[0].url : '',
				index:     response.playlist_cur_index,
				duration:  parseInt(response.duration) || 0,
				playtime:  parseInt(response.time),
				timestamp: response.playlist_timestamp,
				player:    playerid
			};
	
			if ((response.power != null) && !response.power) {
				this.playerStatus.power = 0;
	//			playTimeTimer.cancel();
			}
		},
	
		_needUpdate : function(result) {
			// the dontUpdate flag allows us to have the timestamp check ignored for one action 
			// used to prevent updates during d'n'd
			if (this.playerStatus.dontUpdate) {
				this.playerStatus.timestamp = result.playlist_timestamp;
				this.playerStatus.dontUpdate = false;
			}
	
			var needUpdate = (result.power && (result.power != this.playerStatus.power));
			needUpdate |= (this.playerStatus.player != playerid);                                                           // changed player
			needUpdate |= (result.mode != null && result.mode != this.playerStatus.mode);                                   // play/paus mode
			needUpdate |= (result.playlist_timestamp != null && result.playlist_timestamp > this.playerStatus.timestamp);   // playlist: time of last change
			needUpdate |= (result.playlist_cur_index != null && result.playlist_cur_index != this.playerStatus.index);      // the currently playing song's position in the playlist 
			needUpdate |= (result.current_title != null && result.current_title != this.playerStatus.current_title);        // title (eg. radio stream)
			needUpdate |= (result.playlist_tracks > 0 && result.playlist_loop[0].title != this.playerStatus.title);         // songtitle?
			needUpdate |= (result.playlist_tracks > 0 && result.playlist_loop[0].url != this.playerStatus.track);           // track url
			needUpdate |= (result.playlist_tracks < 1 && this.playerStatus.track);                                          // there's a player, but no song in the playlist
			needUpdate |= (result.playlist_tracks > 0 && !this.playerStatus.track);                                         // track in playlist changed
			needUpdate |= (result.rate != null && result.rate != this.playerStatus.rate);                                   // song is scanning (ffwd/frwd)
	
			return needUpdate;
		},
	
		setVolume : function(amount, d){
			amount *= 10;
			if (d)
				amount = d + amount;
			this.playerControl(['mixer', 'volume', amount]);
		},
	
		setPlayer : function(player){
			this.player = player;

			// remember the selected player
			if (player)
				SqueezeJS.setCookie('SqueezeCenter-player', player);

			this.fireEvent('playerselected', player);

			// legacy global variables for compatibility
			playerid = player;
			player = encodeURI(player);
		},
	
		getPlayer : function(){
			return this.player;
		}
	});
}

SqueezeJS.getPlayer = SqueezeJS.Controller.getPlayer;


SqueezeJS.SonginfoParser = {
	tpl : {
		raw : {
			title : new Ext.Template('{title}'),
			album : new Ext.Template('{album}'),
			contributor : new Ext.Template('{contributor}'),
			year : new Ext.Template('{year}'),
			coverart : new Ext.Template('<img src="{src}" width="{width}">')
		},
		linked : {
			title : new Ext.Template('<a href="' + webroot +'{link}?player={player}&amp;item={id}" target="browser">{title}</a>'),
			album : new Ext.Template('<a href="' + webroot + 'browsedb.html?hierarchy=album,track&amp;level=1&amp;album.id={id}&amp;player={player}" target="browser">{album}</a>'),
			contributor : new Ext.Template('<a href="' + webroot + 'browsedb.html?hierarchy=contributor,album,track&amp;contributor.id={id}&amp;level=1&amp;player={player}" target="browser">{contributor}</a>'),
			year : new Ext.Template('<a href="' + webroot + 'browsedb.html?hierarchy=year,album,track&amp;level=1&amp;year.id={year}&amp;player={player}" target="browser">{year}</a>'),
			coverart : new Ext.Template('<a href="' + webroot + '{link}?player={player}&amp;item={id}" target="browser"><img src="{src}" width="{width}"></a>')
		}
	},

	title : function(result, noLink, noRemoteTitle){
		var title;
		var link;
		var id;

		if (result.playlist_tracks > 0) {
			if (result.current_title) 
				title = result.current_title;
	
			else if (result.playlist_loop[0].remote_title && !noRemoteTitle)
				title = result.playlist_loop[0].remote_title;
	
			else
				title = (result.playlist_loop[0].disc ? result.playlist_loop[0].disc + '-' : '')
						+ (result.playlist_loop[0].tracknum ? result.playlist_loop[0].tracknum + ". " : '')
						+ result.playlist_loop[0].title;

			link = result.playlist_loop[0].info_link || 'songinfo.html';
			id = result.playlist_loop[0].id;
		}

		return this.tpl[(noLink ? 'raw' : 'linked')].title.apply({
			link: link,
			id: id,
			title: title,
			player: SqueezeJS.getPlayer()
		});
	},

	album : function(result, noLink){
		var album = '';
		var id = null;

		if (result.playlist_tracks > 0) {
			if (result.playlist_loop[0].album) {
				if (result.playlist_loop[0].album_id)
					id = result.playlist_loop[0].album_id;
	
				album = result.playlist_loop[0].album;
			}
	
			else if (result.playlist_loop[0].remote_title && result.playlist_loop[0].title)
				album = result.playlist_loop[0].title;
		}

		return this.tpl[((noLink || id == null) ? 'raw' : 'linked')].album.apply({
			id: id,
			album: album,
			player: SqueezeJS.getPlayer()
		});
	},

	contributors : function(result, noLink){
		var currentContributors = new Array();
		var contributorRoles = SqueezeJS.contributorRoles;

		var contributorList = '';
		if (result.playlist_tracks > 0) {
			for (var x = 0; x < contributorRoles.length; x++) {
				if (result.playlist_loop[0][contributorRoles[x]]) {
					var contributors = result.playlist_loop[0][contributorRoles[x]].split(',');
					var ids = result.playlist_loop[0][contributorRoles[x] + '_ids'] ? result.playlist_loop[0][contributorRoles[x] + '_ids'].split(',') : new Array();
	
					for (var i = 0; i < contributors.length; i++) {
						// only add to the list if it's not already in there
						if (!currentContributors[contributors[i]]) {
							currentContributors[contributors[i]] = 1;
	
							if (contributorList)
								contributorList += ', ';

							contributorList += this.tpl[((ids[i] && !noLink) ? 'linked' : 'raw')].contributor.apply({ 
								id: (ids[i] || null),
								contributor: contributors[i],
								player: SqueezeJS.getPlayer()
							});
						}
					}
				}
			}
		}

		return contributorList;
	},

	year : function(result, noLink){
		var year;

		if (result.playlist_tracks > 0 && parseInt(result.playlist_loop[0].year) > 0)
				year = parseInt(result.playlist_loop[0].year);

		return this.tpl[(noLink || !year ? 'raw' : 'linked')].year.apply({
			year: year,
			player: SqueezeJS.getPlayer()
		});
	},

	bitrate : function(result){
		var bitrate = '';

		if (result.playlist_tracks > 0 && result.playlist_loop[0].bitrate && result.remote) {
			bitrate = result.playlist_loop[0].bitrate
				+ (result.playlist_loop[0].type
					? ', ' + result.playlist_loop[0].type
					: ''
				);
		}

		return bitrate;
	},

	coverart : function(result, noLink, width){
		var coverart = '/music/0/cover' + (width ? '_' + width + 'x' + width + '_p.' : '.') + SqueezeJS.coverFileSuffix;
		var id = 0;
		var link;

		if (result.playlist_tracks > 0) {
			coverart = this.coverartUrl(result, width);

			if (result.playlist_loop[0].id) {
				id = result.playlist_loop[0].id;
				link = result.playlist_loop[0].info_link || 'songinfo.html';
			}
		}

		return this.tpl[((noLink || id == null) ? 'raw' : 'linked')].coverart.apply({
			id: id,
			src: coverart,
			width: width,
			link: link
		});
	},

	coverartUrl : function(result, width){
		var coverart = '/music/0/cover' + (width ? '_' + width + 'x' + width + '_p.' : '.') + SqueezeJS.coverFileSuffix;
		var link;

		if (result.playlist_tracks > 0) {
			if (result.playlist_loop[0].artwork_url) {
				coverart = result.playlist_loop[0].artwork_url;
			}
			else {
				coverart = '/music/' + (result.playlist_loop[0].id || 0) + '/cover' + (width ? '_' + width + 'x' + width + '_p.' : '.') + SqueezeJS.coverFileSuffix;
			}
		}

		return coverart;
	}
};

