SqueezeJS.Utils = {
	formatTime : function(seconds){
		var remaining;

		if (seconds < 0) {
			remaining = true;
			seconds = Math.abs(seconds);
		}
		
		var hours = Math.floor(seconds / 3600);
		var minutes = Math.floor((seconds - hours*3600) / 60);
		seconds = Math.floor(seconds % 60);

		var formattedTime = (hours ? hours + ':' : '');
		formattedTime += (minutes ? (minutes < 10 && hours ? '0' : '') + minutes : '0') + ':';
		formattedTime += (seconds ? (seconds < 10 ? '0' : '') + seconds : '00');
		return (remaining ? '-' : '') + formattedTime;
	}
};

// our own cookie manager doesn't prepend 'ys-' to any cookie
SqueezeJS.CookieManager = new Ext.state.CookieProvider({
	expires : new Date(new Date().getTime() + 1000*60*60*24*365),

	readCookies : function(){
		var cookies = {};
		var c = document.cookie + ";";
		var re = /\s?(.*?)=(.*?);/g;
		var matches;
		while((matches = re.exec(c)) != null){
			var name = matches[1];
			var value = matches[2];
			if(name){
				cookies[name] = value;
			}
		}
		return cookies;
	},

	setCookie : function(name, value){
		document.cookie = name + "=" + value +
		((this.expires == null) ? "" : ("; expires=" + this.expires.toGMTString())) +
		((this.path == null) ? "" : ("; path=" + this.path)) +
		((this.domain == null) ? "" : ("; domain=" + this.domain)) +
		((this.secure == true) ? "; secure" : "");
	},

	clearCookie : function(name){
		document.cookie = name + "=null; expires=Thu, 01-Jan-70 00:00:01 GMT" +
			((this.path == null) ? "" : ("; path=" + this.path)) +
			((this.domain == null) ? "" : ("; domain=" + this.domain)) +
			((this.secure == true) ? "; secure" : "");
	}
});

SqueezeJS.setCookie = function(name, value) {
	SqueezeJS.CookieManager.set(name, value);
};

SqueezeJS.getCookie = function(name, failover) {
	return SqueezeJS.CookieManager.get(name, failover);
};

SqueezeJS.clearCookie = function(name, failover) {
	return SqueezeJS.CookieManager.clear(name);
};


// some legacy calls....

function setCookie(name, value) {
	Utils.setCookie(name, value);
}
