package Plugins::BrowseMenuRemover::Settings;

use strict;
use base qw(Slim::Web::Settings);

use File::Basename;
use File::Next;

use Slim::Utils::Log;
use Slim::Utils::Prefs;
use Slim::Utils::Misc;

my $prefs = preferences('plugin.browsemenuremover');
my $log   = logger('plugin.browsemenuremover');

my $plugin; # reference to main plugin

$prefs->migrate(1, sub {
        $prefs->set('browsebyartist', Slim::Utils::Prefs::OldPrefs->get('browsemenuremover-browsebyartist') || 1           );
	$prefs->set('browsebyalbum', Slim::Utils::Prefs::OldPrefs->get('browsemenuremover-browsebyalbum') || 1           );
	$prefs->set('browsebygenre', Slim::Utils::Prefs::OldPrefs->get('browsemenuremover-browsebygenre') || 1           );
	$prefs->set('browsebyyear', Slim::Utils::Prefs::OldPrefs->get('browsemenuremover-browsebyyear') || 1           );
	$prefs->set('browsenewmusic', Slim::Utils::Prefs::OldPrefs->get('browsemenuremover-browsenewmusic') || 1           );
        1;
});

sub new {
	my $class = shift;
	$plugin   = shift;

	$class->SUPER::new;
}

sub name {
	return 'PLUGIN_BROWSEMENUREMOVER';
}

sub page {
	return 'plugins/BrowseMenuRemover/settings/basic.html';
}

sub prefs {
        return ($prefs, qw(browsebyartist browsebyalbum browsebygenre browsebyyear browsenewmusic) );
}

sub handler {
	my ($class, $client, $params) = @_;

	if($params->{'browsebyartist'}) {
		Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_ARTIST' => "browsedb.html?hierarchy=contributor,album,track&level=0" });
	}else { 
		Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_ARTIST' => undef });
	}
	if($params->{'browsebyalbum'}) {
		Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_ALBUM'  => "browsedb.html?hierarchy=album,track&level=0" });
	}else {
		Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_ALBUM'  => undef });
	}
	if($params->{'browsebygenre'}) {
		Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_GENRE'  => "browsedb.html?hierarchy=genre,contributor,album,track&level=0" });
	}else {
		Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_GENRE'  => undef });
	}
	if($params->{'browsebyyear'}) {
		Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_YEAR'   => "browsedb.html?hierarchy=year,album,track&level=0" });
	}else {
		Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_YEAR'   => undef });
	}
	if($params->{'browsenewmusic'}) {
		Slim::Web::Pages->addPageLinks("browse", {'BROWSE_NEW_MUSIC' => "browsedb.html?hierarchy=age,track&level=0" });
	}else {
		Slim::Web::Pages->addPageLinks("browse", {'BROWSE_NEW_MUSIC' => undef });
	}
	return $class->SUPER::handler($client, $params);
}

		
1;
