package Plugins::BrowseMenuRemover::Plugin;

# BrowseMenuRemover - a test plugin that removes standard browse menus for slimserver 7.0

use strict;

use base qw(Slim::Plugin::Base);

use File::Spec::Functions qw(:ALL);

use Slim::Utils::Log;
use Slim::Utils::Prefs;
use Slim::Utils::Misc;
use Slim::Utils::Strings;

my $log = Slim::Utils::Log->addLogCategory({
	'category'     => 'plugin.browsemenuremover',
	'defaultLevel' => 'WARN',
	'description'  => getDisplayName(),
});

use Plugins::BrowseMenuRemover::Settings;

my $prefs = preferences('plugin.browsemenuremover');

sub initPlugin {
	my $class = shift;

	$class->SUPER::initPlugin;

	if($prefs->get('browsebyartist')) {
                Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_ARTIST' => "browsedb.html?hierarchy=contributor,album,track&level=0" });
        }else {
                Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_ARTIST' => undef });
        }
        if($prefs->get('browsebyalbum')) {
                Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_ALBUM'  => "browsedb.html?hierarchy=album,track&level=0" });
        }else {
                Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_ALBUM'  => undef });
        }
        if($prefs->get('browsebygenre')) {
                Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_GENRE'  => "browsedb.html?hierarchy=genre,contributor,album,track&level=0" });
        }else {
                Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_GENRE'  => undef });
        }
        if($prefs->get('browsebyyear')) {
                Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_YEAR'   => "browsedb.html?hierarchy=year,album,track&level=0" });
        }else {
                Slim::Web::Pages->addPageLinks("browse", {'BROWSE_BY_YEAR'   => undef });
        }
        if($prefs->get('browsenewmusic')) {
                Slim::Web::Pages->addPageLinks("browse", {'BROWSE_NEW_MUSIC' => "browsedb.html?hierarchy=age,track&level=0" });
        }else {
                Slim::Web::Pages->addPageLinks("browse", {'BROWSE_NEW_MUSIC' => undef });
        }

	Plugins::BrowseMenuRemover::Settings->new($class);
}

sub getDisplayName { 'PLUGIN_BROWSEMENUREMOVER' };


1;
