package Plugins::FolderChooser::Plugin;

use strict;
use Path::Class;
use File::Basename;
use File::Spec::Functions qw(:ALL);

use base qw(Slim::Plugin::Base);
use Slim::Utils::Log;
use Slim::Utils::Strings qw (string);

BEGIN {
        if ($^O =~ /Win32/) {
                require Win32::File;
                require Win32::DriveInfo;
        }
}

use vars qw($VERSION);
$VERSION = substr( q$Revision: 0.01 $, 10 );

my $log = Slim::Utils::Log->addLogCategory({
	'category'     => 'plugin.folderchooser',
	'defaultLevel' => 'WARN',
	'description'  => getDisplayName(),
});

my $htmlTemplate = 'plugins/FolderChooser/index.html';

sub getDisplayName {
	return 'PLUGIN_FOLDERCHOOSER';
}

sub initPlugin {
	my $class = shift;
	$class->SUPER::initPlugin();
}

sub webPages {
	my $class = shift;
	Slim::Web::Pages->addPageLinks('plugins', { getDisplayName() => $htmlTemplate });
	Slim::Web::HTTP::addPageFunction($htmlTemplate, \&handlePage);
}

sub handlePage {
	my ($client, $params) = @_;
	my $curdir = $params->{'curdir'};

	my @subdirs;
	my @pathparts;

	# do something useful with the current path (store it, transfer to path input field etc.)
	if ($curdir && $params->{'savePath'}) {
		$params->{'saved'} = 1;
	}

	# show folder based on current folder (relative new path)
	if ($curdir && $params->{'newdir'} &&  $params->{'newdir'} eq '..') {
		@pathparts = splitdir($curdir);
		
		# argh... can't just add '..' on *X systems...
		if (Slim::Utils::OSDetect::OS() eq 'win') {
			$curdir = canonpath(catdir($curdir, '..'));
		}
		else {
			$curdir = canonpath(join('/', @pathparts[0..$#pathparts-1]));
		}
	}

	elsif ($curdir && $params->{'newdir'}) {
		$curdir = canonpath(catdir($curdir, $params->{'newdir'}));
	}

	# show folder, absolute path
	elsif ($params->{'newdir'} && $params->{'newdir'} ne '..') {
		$curdir = canonpath($params->{'newdir'});
	}

	# current folder is invalid
	elsif (!($curdir && Slim::Utils::Validate::isDir($curdir, 0))) {
		$curdir = Slim::Utils::Prefs::get('audiodir');
	}

	# still no correct path - display root
	if (! ($curdir && Slim::Utils::Validate::isDir($curdir, 0))) {
		$curdir = rootdir();
	}

	# handle Windows differently: allow to climb up above the root, display drives
	if (Slim::Utils::OSDetect::OS() eq 'win'
		&& (($params->{'curdir'} eq $curdir && $params->{'newdir'} eq '..')
			|| $curdir eq rootdir())) {

 		@subdirs = map { "$_:\\" } Win32::DriveInfo::DrivesInUse();
		$params->{'curdir'} = undef;
		@pathparts = undef;
	}

	elsif (Slim::Utils::Validate::isDir($curdir, 0)) {
		eval {
			my $dir = Path::Class::Dir->new($curdir);
			@subdirs = $dir->children();
		};

		@subdirs = sort { uc($a) cmp uc($b) }
				map { basename($_->stringify) }
				grep { filterFolders($_) } @subdirs;

		$params->{'curdir'} = canonpath($curdir);
		@pathparts = splitdir($curdir);
		unshift @pathparts, '/' if (Slim::Utils::OSDetect::OS() ne 'win');
	}

	else {
		$params->{'invalid'} = 1;
	}

	$params->{'subdirs'} = \@subdirs;
	$params->{'pathparts'} = \@pathparts;

	return Slim::Web::HTTP::filltemplatefile($htmlTemplate, $params);
}

sub filterFolders {
	my $folder = shift;
	return 0 if !($folder->isa('Path::Class::Dir'));

	if (Slim::Utils::OSDetect::OS() eq 'win') {
		my $attribs;
		return Win32::File::GetAttributes($folder, $attribs) && !($attribs & Win32::File::HIDDEN());
	}

	return 1;
}

1;