# PreventStandby.pm by Julian Neil (julian.neil@internode.on.net)
#
# Prevent the server machine from going into standby when it is streaming
# music to any clients.  Only works in Windows because it uses the CPAN
# Win32:API module.
#
# Excuse my perl.. first time I've ever used it.
#
# Thanks to the PowerSave plugin by Jason Holtzapplefor some basics,
# to various ppl on the slim forums and to CPAN and the Win32::API module.
#
#-> Changelog
#
# 1.0 - 2006-04-05 - Initial Release

package Plugins::PreventStandby::Plugin;

use strict;

use Slim::Utils::Misc;
use Win32::API;

use vars qw($VERSION);
$VERSION = '1.0';


my $interval = 60;                          # how many seconds between checks for playing clients
my $timer = undef;                          # keep the timer so we can kill it if we want
my $SetThreadExecutionState = undef;        # reference to the windows function of same name

sub getDisplayName() 
{
    return 'PLUGIN_PREVENTSTANDBY';
}

sub checkClientActivity 
{
    $timer = undef;
    foreach my $client (Slim::Player::Client::clients()) 
    {
        my $playmode = $client->playmode();
        $::d_plugins && msgf("Prevent Standby plugin: client %s in playmode %s\n",$client->name(), $playmode);
        if ($playmode ne 'stop' && $playmode ne 'pause')
        {
            $::d_plugins && msg("Prevent Standby plugin: setting thread execution state\n");
            $SetThreadExecutionState->Call(1) if ($SetThreadExecutionState != undef);
            startTimer();
            return 1;
        }
    }
    startTimer();
    return 0;
}

sub startTimer 
{
    if ($timer == undef && $SetThreadExecutionState != undef)
    {
        $::d_plugins && msg("Prevent Standby plugin: starting timer\n");
        $timer = Slim::Utils::Timers::setTimer (0, time + $interval, \&checkClientActivity);
        $::d_plugins && ($timer == undef) && msg("Prevent Standby plugin: starting timer failed\n");
    }
    return $timer != undef
}

sub stopTimer
{
    unless ($timer == undef)
    {
        Slim::Utils::Timers::killSpecific($timer);
    }
    $timer = undef;
}

sub initPlugin 
{
    if (Slim::Utils::OSDetect::OS() eq 'win')
    {
        $SetThreadExecutionState = Win32::API->new('kernel32', 'SetThreadExecutionState', 'N', 'N');
    }
    else
    {
        $::d_plugins && msg("Prevent Standby plugin: Only available under Windows\n");
    }
    return startTimer();
}

sub shutdownPlugin {
    stopTimer();
}

sub strings { return '
PLUGIN_PREVENTSTANDBY
	EN	Prevent Standby While Playing
'};

1;

__END__
