
package Plugins::testFileName;

use strict;

use Slim::Networking::SimpleAsyncHTTP;
use Slim::Utils::Misc;

our %functions;

# list of playlist commands that stop nagog random play

sub getDisplayName {
    return 'PLUGIN_TESTFILENAME';
}

sub enabled {
    return ($::VERSION ge '6.1');
}

sub initPlugin {

	%functions = (
		'up' => sub  {
			my $client = shift;
			$client->bumpUp();
		},
	);

	Slim::Control::Command::setExecuteCallback(\&commandCallback);
}

sub shutdownPlugin {
    Slim::Control::Command::clearExecuteCallback(\&commandCommandCallback);
}

sub setMode {
	my $client = shift;

	$client->lines(\&lines);
}

sub lines {
	my $client = shift;
	return {
	    'line1' => $client->string('PLUGIN_TESTFILENAME'),
	    'line2' => "",
	};
}

sub getFunctions() {
	return \%functions;
}

sub strings {
	return q^PLUGIN_TESTFILENAME
	EN	testFileName^;
}

#######################################################################

# for testing unencoded ';' 
my $trackUnencodedSemicolon = "file:///export1/audio/cd/v/a/Various%20(Ronald%20Stein)%20~%20Not%20of%20this%20Earth!%20-%20The%20Film%20Music%20of%20Ronald%20Stein%20~%2007%20~%20Attack%20of%20the%2050%20Ft.%20Woman%20-%20Nancy%20Got%20Her%20Man;%20Big%20Finish.flac";

# for testing encoded ';' (3B) 
my $trackEncodedSemicolon = "file:///export1/audio/cd/v/a/Various%20(Ronald%20Stein)%20~%20Not%20of%20this%20Earth!%20-%20The%20Film%20Music%20of%20Ronald%20Stein%20~%2007%20~%20Attack%20of%20the%2050%20Ft.%20Woman%20-%20Nancy%20Got%20Her%20Man%3B%20Big%20Finish.flac";

sub appendTrack {
    my $client = shift;
    my $track = $trackUnencodedSemicolon;

    if (defined $client) {
	$::d_plugins && msg("testFileName.appendTrack: track [" . $track . "]\n");

	$track = Slim::Web::HTTP::unescape($track);
	$::d_plugins && msg("testFileName.appendTrack: track [" . $track . "]\n");

	Slim::Control::Command::clearExecuteCallback(\&commandCallback);

	Slim::Player::Playlist::shuffle($client, 0);

	$client->execute(['playlist', 'insert', $track]);
      
	# Never show random as modified, since its a living playlist
	$client->currentPlaylistModified(0);

	Slim::Control::Command::setExecuteCallback(\&commandCallback);
    }
    else {
	$::d_plugins && ( ! defined $client) && msg("testFileName.appendTrack: client is undefined\n");
    }
}

#######################################################################
### commandCallback

sub commandCallback {
    my ($client, $paramsRef) = @_;
    my $slimCommand = $paramsRef->[0];

    $::d_plugins && msgf("testFileName.ccb: received command %s\n", join(' ', @$paramsRef));

    if ( ! defined $client) {
	if ($::d_plugins) {
	    msg("testFileName.ccb: No client!\n");
	    bt();
	}
	return;
    }

    my $songIndex = Slim::Player::Source::streamingSongIndex($client);
    my $playlistCount = Slim::Player::Playlist::count($client);
    if ($::d_plugins) {
	my $clientName = $client->name;
	msg "testFileName.ccb: received command: $slimCommand, from $clientName, song index = $songIndex, playlistCount = $playlistCount\n";
    }
    if ($slimCommand eq 'newsong' || 
	$slimCommand eq 'playlist' && 
	$paramsRef->[1] eq 'delete' && $paramsRef->[2] > $songIndex) {

	# if this is the last track in the list, call getNextTrack
	if ($songIndex == $playlistCount - 1) {
	    $::d_plugins && msg "testFileName.ccb: last track in list, calling appendTrack\n";
	    appendTrack($client);
	}
    }
    elsif ($slimCommand eq 'play') {
	my $playlistCount = Slim::Player::Playlist::count($client);
	if ($playlistCount <= 0) {
	    $::d_plugins && msg "testFileName.ccb: playlist is empty, getNextTrack twice\n";
	    appendTrack($client);
	}
    }
    elsif ($slimCommand eq 'stop' || 
	   $slimCommand eq 'power' && ! $client->power()) {
	$::d_plugins && msg "testFileName.ccb: stop or power off\n";
    }
}

1;
